/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;

public class JsonTypeLoader
implements TypeLoader {
    public static MetadataFormat JSON = new MetadataFormat("Json", "json", new String[]{"text/json", "application/json"});
    private File schemaFile;

    public JsonTypeLoader(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MetadataType> load(String identifier) {
        try (FileInputStream inputStream = new FileInputStream(this.schemaFile);){
            JSONObject rawSchema = new JSONObject(new JSONTokener((InputStream)inputStream));
            Schema jsonSchema = SchemaLoader.load((JSONObject)rawSchema);
            Optional<MetadataType> optional = Optional.of(new HandlerManager().handle(jsonSchema, new ParsingContext()).build());
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

