/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.handler;

import java.util.List;
import java.util.Optional;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.json.handler.SchemaHandler;
import org.mule.metadata.utils.StringUtils;

public class ArrayHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ArraySchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext) {
        Schema arrayType;
        String title;
        ArraySchema arraySchema = (ArraySchema)schema;
        if (arraySchema.getItemSchemas() != null && !arraySchema.getItemSchemas().isEmpty()) {
            String title2;
            List itemSchemas = arraySchema.getItemSchemas();
            TupleTypeBuilder tupleType = root.tupleType();
            String description = arraySchema.getDescription();
            if (StringUtils.isNotEmpty((String)description)) {
                tupleType.description(description);
            }
            if (StringUtils.isNotEmpty((String)(title2 = arraySchema.getTitle()))) {
                tupleType.label(title2);
            }
            for (Schema itemSchema : itemSchemas) {
                tupleType.of(handlerManager.handle(itemSchema, parsingContext));
            }
            return tupleType;
        }
        ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
        String description = arraySchema.getDescription();
        if (StringUtils.isNotEmpty((String)description)) {
            arrayMetadataBuilder.description(description);
        }
        if (StringUtils.isNotEmpty((String)(title = arraySchema.getTitle()))) {
            arrayMetadataBuilder.label(title);
        }
        if (arraySchema.needsUniqueItems()) {
            arrayMetadataBuilder.uniques();
        }
        Optional<Object> min = Optional.empty();
        Optional<Object> max = Optional.empty();
        if (arraySchema.getMinItems() != null && arraySchema.getMinItems() > 0) {
            min = Optional.of(arraySchema.getMinItems());
        }
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() > 0) {
            max = Optional.of(arraySchema.getMaxItems());
        }
        if (max.isPresent() || min.isPresent()) {
            arrayMetadataBuilder.boundary(min, max);
        }
        if ((arrayType = arraySchema.getAllItemSchema()) != null) {
            arrayMetadataBuilder.of(handlerManager.handle(arrayType, parsingContext));
        } else {
            arrayMetadataBuilder.of().anyType();
        }
        return arrayMetadataBuilder;
    }
}

