/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.handler;

import java.util.Optional;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.json.handler.SchemaHandler;

public class NumberHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof NumberSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext) {
        NumberSchema numberSchema = (NumberSchema)schema;
        NumberTypeBuilder numberType = root.numberType();
        Optional<Object> min = Optional.empty();
        Optional<Object> max = Optional.empty();
        if (numberSchema.getMinimum() != null) {
            min = Optional.of(numberSchema.getMinimum());
        }
        if (numberSchema.getMaximum() != null) {
            max = Optional.of(numberSchema.getMaximum());
        }
        if (min.isPresent() || max.isPresent()) {
            numberType.range(min, max);
        }
        if (numberSchema.requiresInteger()) {
            numberType.integer();
        }
        return numberType;
    }
}

