/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.handler;

import java.util.Optional;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.json.handler.SchemaHandler;

public class StringHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof StringSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext) {
        StringSchema stringSchema = (StringSchema)schema;
        StringTypeBuilder stringType = root.stringType();
        Optional<Object> min = Optional.empty();
        Optional<Object> max = Optional.empty();
        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0) {
            min = Optional.of(stringSchema.getMinLength());
        }
        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0) {
            max = Optional.of(stringSchema.getMaxLength());
        }
        if (min.isPresent() || max.isPresent()) {
            stringType.boundary(min, max);
        }
        if (stringSchema.getPattern() != null) {
            stringType.pattern(stringSchema.getPattern().toString());
        }
        return stringType;
    }
}

