/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.KEY;
import static org.mule.metadata.persistence.MetadataTypeConstants.VALUE;
import static org.mule.metadata.persistence.deserializer.SerializerUtils.VOLATILE_FORMAT;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DictionaryTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonObject;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link DictionaryType} and returns a {@link DictionaryTypeBuilder}
 *
 * @since 1.0
 */
final class DictionaryTypeDeserializer extends AbstractTypeDeserializer
{

    DictionaryTypeDeserializer()
    {
        super(BaseTypeBuilder::dictionaryType);
    }

    @Override
    public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader)
    {
        final DictionaryTypeBuilder dictionaryTypeBuilder = (DictionaryTypeBuilder) supplier.get(baseBuilder);
        parseAnnotations(typeObject, dictionaryTypeBuilder);
        dictionaryTypeBuilder.ofKey(typeLoader.buildType(typeObject.get(KEY), new BaseTypeBuilder(VOLATILE_FORMAT)));
        dictionaryTypeBuilder.ofValue(typeLoader.buildType(typeObject.get(VALUE), new BaseTypeBuilder(VOLATILE_FORMAT)));
        return dictionaryTypeBuilder;
    }
}
