/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.model.NumberType;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link NumberType} and returns a {@link NumberTypeBuilder}
 *
 * @since 1.0
 */
class NumberTypeDeserializer extends AbstractTypeDeserializer
{

    NumberTypeDeserializer()
    {
        super(BaseTypeBuilder::numberType);
    }
}
