/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.ANNOTATIONS;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.TypeAnnotationSerializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Class that provides common utilities for {@link MetadataType} serialization purposes
 *
 * @since 1.0
 */
final class SerializerUtils
{

    static List<TypeAnnotation> getAnnotations(JsonObject type)
    {
        if (type.has(ANNOTATIONS))
        {
            final JsonObject annotations = type.get(ANNOTATIONS).getAsJsonObject();
            List<TypeAnnotation> annotationList = new ArrayList<>();

            for (Map.Entry<String, JsonElement> annotation : annotations.entrySet())
            {
                final Optional<TypeAnnotation> typeAnnotation = parseTypeAnnotation(annotation);
                if (typeAnnotation.isPresent())
                {
                    annotationList.add(typeAnnotation.get());
                }
            }
            return annotationList;
        }
        else
        {
            return Collections.emptyList();
        }
    }

    private static Optional<TypeAnnotation> parseTypeAnnotation(Map.Entry<String, JsonElement> annotation)
    {
        return new TypeAnnotationSerializer<>().deserialize(annotation.getKey(), annotation.getValue().toString());
    }

    //This format is used to workaround the limitation in the BaseBuilder to create a instance with out a MetadataFormat and will always be overridden
    static MetadataFormat VOLATILE_FORMAT = new MetadataFormat("", "id");
}
