/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonObject;

/**
 * Interface that represents a deserializer for a concrete {@link MetadataType}
 *
 * @since 1.0
 */
@FunctionalInterface
public interface TypeDeserializer
{

    TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader);
}
