/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.deserializer.SerializerUtils.VOLATILE_FORMAT;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link UnionType} and returns a {@link UnionTypeBuilder}
 *
 * @since 1.0
 */
final class UnionTypeDeserializer extends AbstractTypeDeserializer
{

    UnionTypeDeserializer()
    {
        super(BaseTypeBuilder::unionType);
    }

    @Override
    public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader)
    {
        final UnionTypeBuilder unionTypeBuilder = (UnionTypeBuilder) supplier.get(baseBuilder);
        for (JsonElement jsonElement : typeObject.get("of").getAsJsonArray())
        {
            unionTypeBuilder.of(typeLoader.buildType(jsonElement, new BaseTypeBuilder(VOLATILE_FORMAT)));
        }
        parseAnnotations(typeObject, unionTypeBuilder);
        return unionTypeBuilder;
    }
}
