/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.MetadataTypeConstants;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.TypeAnnotationNameClassMapping;
import org.mule.metadata.persistence.TypeAnnotationSerializer;

public class JsonMetadataTypeWriter
extends MetadataTypeVisitor
implements TypeWriter {
    private static final String UNEXPECTED_ERROR_OCCURRED_SERIALIZING = "Unexpected error occurred serializing %s";
    private static final String INDENT_TAB = "  ";
    private static final TypeAnnotationNameClassMapping annotationsNameClassMapping = new TypeAnnotationNameClassMapping();
    private final ObjectTypeReferenceHandler referenceHandler;
    private boolean prettyPrint;
    private JsonWriter writer;
    private Stack<MetadataType> typeStack;
    private TypeAnnotationSerializer<TypeAnnotation> typeAnnotationSerializer = new TypeAnnotationSerializer();

    public JsonMetadataTypeWriter() {
        this(new NullObjectTypeReferenceHandler());
    }

    public JsonMetadataTypeWriter(ObjectTypeReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    public String toString(MetadataType structure) {
        try {
            StringWriter out = new StringWriter();
            this.writer = new JsonWriter((Writer)out);
            if (this.prettyPrint) {
                this.writer.setIndent(INDENT_TAB);
            }
            this.write(structure, this.writer);
            return out.toString();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "MetadataType"), e);
        }
    }

    public void write(MetadataType metadataType, JsonWriter jsonWriter) throws IOException {
        this.writer = jsonWriter;
        this.typeStack = new Stack();
        this.write(metadataType);
    }

    public JsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    private void write(MetadataType type) throws IOException {
        this.write(type, Collections.emptyList(), Collections.emptyMap());
    }

    private void write(MetadataType type, Collection<AttributeFieldType> attributes, Map<String, String> additionalProperties) throws IOException {
        if (this.typeStack.contains(type)) {
            int indexOf = this.typeStack.indexOf(type);
            int reference = this.typeStack.size() - indexOf;
            String ref = "#";
            for (int i = 0; i < reference; ++i) {
                if (i > 0) {
                    ref = ref + "/";
                }
                ref = ref + "..";
            }
            this.writer.value(ref);
        } else {
            this.writer.beginObject();
            for (Map.Entry<String, String> property : additionalProperties.entrySet()) {
                this.writer.name(property.getKey()).value(property.getValue());
            }
            MetadataFormat metadataFormat = type.getMetadataFormat();
            if (this.typeStack.isEmpty() || metadataFormat != this.typeStack.peek().getMetadataFormat()) {
                this.writer.name("format");
                if (MetadataTypeConstants.commonMetadataFormats.contains(metadataFormat)) {
                    this.writer.value(metadataFormat.getId());
                } else {
                    this.writer.beginObject();
                    this.writer.name("id").value(metadataFormat.getId());
                    if (metadataFormat.getLabel().isPresent()) {
                        this.writer.name("label").value((String)metadataFormat.getLabel().get());
                    }
                    this.writer.name("validMimeTypes");
                    this.writer.beginArray();
                    for (String s : metadataFormat.getValidMimeTypes()) {
                        this.writer.value(s);
                    }
                    this.writer.endArray();
                    this.writer.endObject();
                }
            }
            this.typeStack.push(type);
            if (!attributes.isEmpty()) {
                this.writer.name("attributes");
                this.writer.beginObject();
                for (AttributeFieldType attribute : attributes) {
                    this.writer.name(attribute.getKey().getName().toString());
                    this.write((MetadataType)attribute.getValue());
                }
                this.writer.endObject();
            }
            type.accept((MetadataTypeVisitor)this);
            this.writer.endObject();
            this.typeStack.pop();
        }
    }

    public void visitAnyType(AnyType anyType) {
        this.writeType((MetadataType)anyType, "Any");
    }

    public void visitArrayType(ArrayType arrayType) {
        this.writeType((MetadataType)arrayType, "Array");
        try {
            this.writer.name("item");
            this.write(arrayType.getType());
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred serializing ObjectType", e);
        }
    }

    public void visitBinaryType(BinaryType binaryType) {
        this.writeType((MetadataType)binaryType, "Binary");
    }

    public void visitBoolean(BooleanType booleanType) {
        this.writeType((MetadataType)booleanType, "Boolean");
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        this.writeType((MetadataType)dateTimeType, "DateTime");
    }

    public void visitDate(DateType dateType) {
        this.writeType((MetadataType)dateType, "Date");
    }

    public void visitNull(NullType nullType) {
        this.writeType((MetadataType)nullType, "Null");
    }

    public void visitNumber(NumberType numberType) {
        this.writeType((MetadataType)numberType, "Number");
    }

    public void visitObject(ObjectType objectType) {
        if (this.referenceHandler.writeReference(objectType, this.writer).isPresent()) {
            return;
        }
        this.writeType((MetadataType)objectType, "Object");
        Collection fields = objectType.getFields();
        try {
            if (objectType.isOrdered()) {
                this.writer.name("ordered").value(true);
            }
            this.writer.name("fields");
            this.writer.beginArray();
            for (ObjectFieldType field : fields) {
                String keyString;
                this.writer.beginObject();
                ObjectKeyType key = field.getKey();
                Set keyAnnotations = key.getAnnotations();
                if (key.isName()) {
                    keyString = key.getName().toString();
                } else {
                    keyString = key.getPattern().toString();
                    RegexPatternAnnotation patternAnnotation = new RegexPatternAnnotation(keyString);
                    if (!keyAnnotations.contains(patternAnnotation)) {
                        keyAnnotations.add(patternAnnotation);
                    }
                }
                HashMap<String, String> stringObjectHashMap = new HashMap<String, String>();
                if (field.isRequired()) {
                    stringObjectHashMap.put("required", "true");
                }
                if (field.isRepeated()) {
                    stringObjectHashMap.put("repeated", "true");
                }
                this.createKeyObject(keyAnnotations, keyString);
                this.createModelObject(field, key, stringObjectHashMap);
                this.writeAnnotations(field.getAnnotations());
                this.writer.endObject();
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred serializing ObjectType", e);
        }
    }

    public void visitString(StringType stringType) {
        this.writeType((MetadataType)stringType, "String");
    }

    public void visitTime(TimeType timeType) {
        this.writeType((MetadataType)timeType, "Time");
    }

    public void visitTuple(TupleType tupleType) {
        this.writeType((MetadataType)tupleType, "Tuple");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List types = tupleType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Tuple"), e);
        }
    }

    public void visitUnion(UnionType unionType) {
        this.writeType((MetadataType)unionType, "Union");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List types = unionType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Union"), e);
        }
    }

    public void visitIntersection(IntersectionType intersectionType) {
        this.writeType((MetadataType)intersectionType, "Intersection");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List types = intersectionType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Intersection"), e);
        }
    }

    public void visitDictionary(DictionaryType dictionaryType) {
        this.writeType((MetadataType)dictionaryType, "Dictionary");
        try {
            this.writer.name("key");
            this.write(dictionaryType.getKeyType());
            this.writer.name("value");
            this.write(dictionaryType.getValueType());
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Dictionary"), e);
        }
    }

    private void writeType(MetadataType metadataType, String type) {
        try {
            this.writer.name("type").value(type);
            this.writeAnnotations(metadataType.getAnnotations());
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, type), e);
        }
    }

    private void writeAnnotations(Collection<TypeAnnotation> annotations) throws IOException {
        if (!annotations.isEmpty()) {
            this.writer.name("annotations");
            this.writer.beginObject();
            for (TypeAnnotation annotation : annotations) {
                this.writer.name(this.getAnnotationJsonName(annotation));
                this.typeAnnotationSerializer.serialize(this.writer, annotation);
            }
            this.writer.endObject();
        }
    }

    private String getAnnotationJsonName(TypeAnnotation annotation) {
        if (annotationsNameClassMapping.getNameClassMapping().containsKey(annotation.getName())) {
            return annotation.getName();
        }
        return annotation.getClass().getName();
    }

    private void createModelObject(ObjectFieldType field, ObjectKeyType key, HashMap<String, String> stringObjectHashMap) throws IOException {
        this.writer.name("model");
        this.write(field.getValue(), key.getAttributes(), stringObjectHashMap);
    }

    private void createKeyObject(Collection<TypeAnnotation> keyAnnotations, String keyString) throws IOException {
        this.writer.name("key");
        this.writer.beginObject();
        this.writer.name("name");
        this.writer.value(keyString);
        this.writeAnnotations(keyAnnotations);
        this.writer.endObject();
    }
}

