/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XSImplementationImpl;
import org.apache.xerces.impl.xs.util.LSInputListImpl;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class ModelFactory {
    private XSModel model;
    private Optional<ExampleAnnotation> example;

    private ModelFactory(XSModel model, ExampleAnnotation example) {
        this.model = model;
        this.example = Optional.ofNullable(example);
    }

    public XSModel getModel() {
        return this.model;
    }

    public Optional<ExampleAnnotation> getExample() {
        return this.example;
    }

    public static ModelFactory fromExample(File exampleFile) {
        try {
            return ModelFactory.fromExample(Files.readAllLines(exampleFile.toPath()).stream().collect(Collectors.joining()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromExample(String exampleXML) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            List<String> schemas = SchemaHelper.generateXSD(exampleXML);
            DOMInputImpl[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> new DOMInputImpl(null, null, null, (Reader)new StringReader((String)schema), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList((LSInputList)new LSInputListImpl((LSInput[])domInputs, domInputs.length));
            return new ModelFactory(model, new ExampleAnnotation(StringEscapeUtils.escapeXml11((String)exampleXML)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromSchemas(List<File> schemas) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            DOMInputImpl[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> {
                try {
                    return new DOMInputImpl(null, schema.toURI().toString(), null, (InputStream)new FileInputStream((File)schema), "UTF-8");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList((LSInputList)new LSInputListImpl((LSInput[])domInputs, domInputs.length));
            return new ModelFactory(model, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XSLoader initializeXSLoader() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementationImpl impl = (XSImplementationImpl)registry.getDOMImplementation("XS-Loader");
        return impl.createXSLoader(null);
    }
}

