/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.handler.BinaryHandler;
import org.mule.metadata.xml.handler.BooleanHandler;
import org.mule.metadata.xml.handler.DateHandler;
import org.mule.metadata.xml.handler.DateTimeHandler;
import org.mule.metadata.xml.handler.NumberHandler;
import org.mule.metadata.xml.handler.StringHandler;
import org.mule.metadata.xml.handler.TimeHandler;
import org.mule.metadata.xml.handler.XmlHandler;
import org.mule.metadata.xml.utils.XmlConstants;

public class HandlerManager {
    private List<XmlHandler> handlers = Arrays.asList(new BinaryHandler(), new DateHandler(), new DateTimeHandler(), new NumberHandler(), new StringHandler(), new TimeHandler(), new BooleanHandler());

    public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder<?> builder) {
        XSSimpleTypeDefinition primitiveType = xsTypeDefinition.getPrimitiveType();
        QName name = primitiveType != null ? new QName(primitiveType.getNamespace(), primitiveType.getName()) : (xsTypeDefinition.getName() != null ? new QName(xsTypeDefinition.getNamespace(), xsTypeDefinition.getName()) : XmlConstants.XSD_STRING);
        for (XmlHandler handler : this.handlers) {
            if (!handler.handles(name)) continue;
            return handler.handle(xsTypeDefinition, defaultValue, builder);
        }
        return new StringHandler().handle(xsTypeDefinition, defaultValue, builder);
    }
}

