/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.handler.XmlHandler;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.mule.metadata.xml.utils.XmlConstants;

public class StringHandler
implements XmlHandler {
    public static final List<QName> STRING_TYPES = Arrays.asList(XmlConstants.XSD_STRING, XmlConstants.XSD_ANY, XmlConstants.XSD_NORMALIZEDSTRING);

    @Override
    public boolean handles(QName schema) {
        return STRING_TYPES.contains(schema);
    }

    @Override
    public TypeBuilder<?> handle(XSSimpleTypeDecl element, Optional<String> defaultValue, BaseTypeBuilder<?> builder) {
        StringTypeBuilder stringType = builder.stringType();
        StringList enumeration = element.getLexicalEnumeration();
        if (!enumeration.isEmpty()) {
            String[] values = (String[])enumeration.toArray((Object[])new String[enumeration.size()]);
            stringType.enumOf(values);
        } else {
            Optional<Integer> length;
            XSMultiValueFacet patternFacet;
            StringList lexicalFacetValues;
            XSObject patternFacetObject;
            if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
                stringType.defaultValue(defaultValue.get());
            }
            if ((patternFacetObject = element.getFacet(8)) instanceof XSMultiValueFacet && (lexicalFacetValues = (patternFacet = (XSMultiValueFacet)patternFacetObject).getLexicalFacetValues()) != null && !lexicalFacetValues.isEmpty()) {
                stringType.pattern(lexicalFacetValues.item(0));
            }
            Optional<Integer> minLength = Optional.ofNullable(element.getFacet(2)).map(SchemaHelper::getIntegerValue);
            Optional<Integer> maxLength = Optional.ofNullable(element.getFacet(4)).map(SchemaHelper::getIntegerValue);
            if (minLength.isPresent() || maxLength.isPresent()) {
                stringType.boundary(minLength, maxLength);
            }
            if ((length = Optional.ofNullable(element.getFacet(1)).map(SchemaHelper::getIntegerValue)).isPresent()) {
                stringType.length(length.get());
            }
        }
        return stringType;
    }
}

