/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.handler;

import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.utils.XmlConstants;

import javax.xml.namespace.QName;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class HandlerManager {

  private List<XmlHandler> handlers =
      Arrays.asList(new BinaryHandler(), new DateHandler(), new DateTimeHandler(), new NumberHandler(), new StringHandler(),
                    new TimeHandler(), new BooleanHandler());

  public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder<?> builder) {
    final QName name;
    final XSSimpleTypeDefinition primitiveType = xsTypeDefinition.getPrimitiveType();
    if (primitiveType != null) {
      name = new QName(primitiveType.getNamespace(), primitiveType.getName());
    } else if (xsTypeDefinition.getName() != null) {
      name = new QName(xsTypeDefinition.getNamespace(), xsTypeDefinition.getName());
    } else {
      name = XmlConstants.XSD_STRING;
    }

    for (XmlHandler handler : handlers) {
      if (handler.handles(name)) {
        return handler.handle(xsTypeDefinition, defaultValue, builder);
      }
    }
    return new StringHandler().handle(xsTypeDefinition, defaultValue, builder);
  }
}
