/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XSImplementationImpl;
import org.apache.xerces.impl.xs.util.LSInputListImpl;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class ModelFactory {
    private XSModel model;
    private Optional<ExampleAnnotation> example;

    private ModelFactory(XSModel model, ExampleAnnotation example) {
        this.model = model;
        this.example = Optional.ofNullable(example);
    }

    public XSModel getModel() {
        return this.model;
    }

    public Optional<ExampleAnnotation> getExample() {
        return this.example;
    }

    public static ModelFactory fromExample(File exampleFile) {
        try {
            return ModelFactory.fromExample(Files.readAllLines(exampleFile.toPath()).stream().collect(Collectors.joining()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromExample(String exampleXML) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            List<String> schemas = SchemaHelper.generateXSD(exampleXML);
            DOMInputImpl[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> new DOMInputImpl(null, null, null, (Reader)new StringReader((String)schema), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList((LSInputList)new LSInputListImpl((LSInput[])domInputs, domInputs.length));
            return new ModelFactory(model, new ExampleAnnotation(StringEscapeUtils.escapeXml11((String)exampleXML)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromSchemas(List<File> schemas) {
        Function<File, InputStream> fileToInputStream = s -> {
            try {
                return new FileInputStream((File)s);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(String.format("Error while getting file: [%s] input stream", s.getName()), e);
            }
        };
        return ModelFactory.createModelFactory(schemas.stream().collect(Collectors.toMap(s -> s.toURI().toString(), fileToInputStream)));
    }

    public static ModelFactory fromSchemas(Set<String> schemas) {
        Function<String, InputStream> urlToInputStream = s -> {
            try {
                return new URL((String)s).openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while getting schema url: [%s] input stream", s), e);
            }
        };
        return ModelFactory.createModelFactory(schemas.stream().collect(Collectors.toMap(s -> s, urlToInputStream)));
    }

    private static ModelFactory createModelFactory(Map<String, InputStream> schemasMap) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            DOMInputImpl[] domInputs = (DOMInputImpl[])schemasMap.entrySet().stream().map(schema -> new DOMInputImpl(null, (String)schema.getKey(), null, (InputStream)schema.getValue(), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList((LSInputList)new LSInputListImpl((LSInput[])domInputs, domInputs.length));
            return new ModelFactory(model, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XSLoader initializeXSLoader() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementationImpl impl = (XSImplementationImpl)registry.getDOMImplementation("XS-Loader");
        return impl.createXSLoader(null);
    }
}

