/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.api.instrument;

/**
 * The {@code LongGauge} interface represents an instrument that records and retrieves long values. This interface extends the
 * {@link Instrument} interface and provides methods to retrieve the current value of the gauge as a long, and to obtain the unit
 * of the measurement.
 */
public interface LongGauge extends Instrument {

  /**
   * Retrieves the current value of the gauge as a long.
   *
   * @return the current value for the gauge.
   */
  long getValueAsLong();

  /**
   * Retrieves the unit associated with the gauge's value.
   *
   * @return a {@code String} representing the unit of the measurement.
   */
  String getUnit();
}
