/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.api.instrument.builder;

import org.mule.metrics.api.instrument.LongCounter;

import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * Builder class for {@link LongCounter}.
 *
 * @since 4.5.0
 */
public interface LongCounterBuilder extends InstrumentBuilder<LongCounter> {

  /**
   * @param consumerForAddOperation the {@link Consumer} to be invoked when the {@link LongCounter#add(long)} is invoked.
   * @return {@link LongCounterBuilder}.
   */
  LongCounterBuilder withConsumerForAddOperation(Consumer<Long> consumerForAddOperation);

  /**
   * @param supplierForIncrementAndGetOperation the {@link Supplier} to be used when {@link LongCounter#incrementAndGetAsInt()}
   *                                            and {@link LongCounter#incrementAndGetAsLong()} are invoked.
   * @return the {@link LongCounterBuilder}.
   */
  LongCounterBuilder withSupplierForIncrementAndGetOperation(Supplier<Long> supplierForIncrementAndGetOperation);

  /**
   * @param valueSupplier the value {@link Supplier} to invoke when {@link LongCounter#getValueAsLong()} and
   *                      {@link LongCounter#getValueAsInt()} are invoked.
   * @return the corresponding {@link LongCounterBuilder}
   */
  LongCounterBuilder withValueSupplier(Supplier<Long> valueSupplier);
}
