/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.api;

import org.mule.metrics.api.instrument.LongCounter;
import org.mule.metrics.api.instrument.LongGauge;
import org.mule.metrics.api.instrument.LongUpDownCounter;
import org.mule.metrics.api.meter.Meter;

/**
 * An exporter for a {@link Meter}.
 */
public interface MeterExporter {

  /**
   * Registers a {@link Meter} whose instruments will be eventually exported.
   * 
   * @param meter the meter to register.
   */
  void registerMeterToExport(Meter meter);

  /**
   * Enables the exportation process for a {@link LongCounter}.
   *
   * @param longCounter the instrument to export.
   */
  void enableExport(LongCounter longCounter);

  /**
   * Enables the exportation process for a {@link LongUpDownCounter}.
   *
   * @param upDownCounter the instrument to export.
   */
  void enableExport(LongUpDownCounter upDownCounter);

  /**
   * Enables the exportation process for a {@link LongGauge}.
   *
   * @param longGauge the instrument to export.
   */
  void enableExport(LongGauge longGauge);

  /**
   * Disposes the {@link MeterExporter}.
   */
  void dispose();
}
