/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.api;

import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.exporter.config.api.NamedMeterComponent;

/**
 * A factory for {@link MeterExporter}
 */
public interface MeterExporterFactory extends NamedMeterComponent {

  /**
   * @param configuration the {@link MeterExporterConfiguration} with the details to create the exporter
   *
   * @return a {@link MeterExporter}.
   */
  MeterExporter getMeterExporter(MeterExporterConfiguration configuration);
}
