/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.config.api;

/**
 * Represents a component in the meter system that has an associated name. Implementations of this interface provide a way to
 * retrieve the name of the component.
 */
public interface NamedMeterComponent {

  /**
   * Retrieves the name of the meter component.
   *
   * @return the name of the meter component as a {@code String}.
   */
  String getName();
}
