/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

import org.mule.metrics.exporter.api.MeterExporterFactory;
import org.mule.metrics.exporter.impl.OpenTelemetryMeterExporterFactory;

/**
 * Definitions for Mule Metrics Exporter Implementation.
 *
 * @moduleGraph
 * @since 4.6
 */
module org.mule.metrics.exporter.impl {

  requires org.mule.metrics.exporter.api;
  requires org.mule.metrics.exporter.configuration.api;
  requires org.mule.metrics.api;

  requires io.opentelemetry.api;
  requires io.opentelemetry.exporter.otlp;
  requires io.opentelemetry.sdk.common;
  requires io.opentelemetry.sdk.metrics;
  requires io.opentelemetry.sdk.testing;
    requires com.google.gson;
    requires org.apache.commons.lang3;

  provides MeterExporterFactory with
          OpenTelemetryMeterExporterFactory;

    exports org.mule.metrics.exporter.impl to
      org.mule.runtime.spring.config,
      spring.beans;
  exports org.mule.metrics.exporter.impl.optel.config to
      org.mule.runtime.spring.config,
      spring.beans;

  opens org.mule.metrics.exporter.impl to
      spring.core;
  opens org.mule.metrics.exporter.impl.optel.config to
      spring.core;

}
