/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.impl.optel.resources.log;

import io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfigurator;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfiguratorException;

public class MulesoftLoggingExporterConfigurator implements MeterExporterConfigurator {

  @Override
  public MetricExporter configExporter(MeterExporterConfiguration meterExporterConfiguration)
      throws MeterExporterConfiguratorException {
    return new MulesoftLoggingMeterExporter();
  }
}
