/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.impl.optel.resources.log;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;

import java.util.ArrayList;
import java.util.Collection;

import static io.opentelemetry.sdk.common.CompletableResultCode.ofSuccess;

public class MulesoftLoggingMeterExporter implements MetricExporter {

  @Override
  public CompletableResultCode export(Collection<MetricData> metricData) {

    Collection<String> names = new ArrayList<>();
    Collection<String> values = new ArrayList<>();

    for (MetricData metric : metricData) {
      names.add(metric.getName());
      Collection<? extends PointData> pointData = metric.getData().getPoints();

      for (PointData point : pointData) {

      }
    }
    for (MetricData metric : metricData) {
      Collection<? extends PointData> pointData = metric.getData().getPoints();
      for (PointData point : pointData) {
        StringBuffer corePricingLogEntry = new StringBuffer(String.format("{\"format\":\"%s\","
            + "\"time\":%d,"
            + "\"events\":"
            + "[{",
                                                                          "v1",
                                                                          point.getEpochNanos()));

        Attributes attributes = point.getAttributes();

        attributes.forEach((key, value) -> {
          corePricingLogEntry.append("\"" + key + "\":\"" + value + "\"");
        });
        System.out.println(corePricingLogEntry);
      }
    }
    return ofSuccess();
  }

  @Override
  public CompletableResultCode flush() {
    return null;
  }

  @Override
  public CompletableResultCode shutdown() {
    return null;
  }

  @Override
  public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
    return AggregationTemporality.CUMULATIVE;
  }
}
