/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metrics.exporter.impl.optel.config;

import java.util.HashMap;
import java.util.Map;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;

public class OpenTelemetryAutoConfigurableMeterExporterConfiguration
implements MeterExporterConfiguration {
    private static final String GRPC_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    private static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    private static final String DEFAULT_EXPORTER_INTERVAL = "60";
    private static final String DEFAULT_ENABLED_VALUE = "false";
    private MeterExporterConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();

    public OpenTelemetryAutoConfigurableMeterExporterConfiguration() {
    }

    public OpenTelemetryAutoConfigurableMeterExporterConfiguration(MeterExporterConfiguration delegate) {
        this.delegate = delegate;
        this.initialiseDefaultConfigurationValues();
    }

    public String getStringValue(String key) {
        String value = this.delegate.getStringValue(key);
        if (value != null) {
            return value;
        }
        return this.defaultConfigurationValues.get(key);
    }

    private void initialiseDefaultConfigurationValues() {
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.enabled", DEFAULT_ENABLED_VALUE);
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.type", "GRPC");
        if (this.getStringValue("mule.openTelemetry.meter.exporter.type").equals("GRPC")) {
            this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.interval", DEFAULT_EXPORTER_INTERVAL);
    }

    public String getName() {
        return "default";
    }
}

