/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.impl;

import static org.mule.metrics.impl.meter.DefaultMeter.builder;

import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.LazyValue;
import org.mule.metrics.api.MeterProvider;
import org.mule.metrics.api.meter.builder.MeterBuilder;
import org.mule.metrics.exporter.api.MeterExporter;
import org.mule.metrics.exporter.api.MeterExporterFactory;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.impl.meter.repository.MeterRepository;

import javax.inject.Inject;

/**
 * A default implementation of the {@link MeterProvider}
 */
public class DefaultMeterProvider implements MeterProvider, Disposable {

  MeterExporterFactory meterExporterFactory;

  MeterExporterConfiguration meterExporterConfiguration;

  MeterRepository meterRepository = new MeterRepository();
  private final LazyValue<MeterExporter> meterExporter = new LazyValue<>(this::resolveMeterExporter);

  @Inject
  public DefaultMeterProvider(MeterExporterFactory meterExporterFactory,
                              MeterExporterConfiguration meterExporterConfiguration) {
    this.meterExporterFactory = meterExporterFactory;
    this.meterExporterConfiguration = meterExporterConfiguration;
  }

  private MeterExporter resolveMeterExporter() {
    return meterExporterFactory.getMeterExporter(meterExporterConfiguration);
  }

  @Override
  public MeterBuilder getMeterBuilder(String meterName) {
    return builder(meterName)
        .withMeterExporter(meterExporter.get())
        .withMeterRepository(meterRepository);
  }

  @Override
  public void close() {
    disposeMeterExporter();
  }

  public MeterRepository getMeterRepository() {
    return meterRepository;
  }

  @Override
  public void dispose() {
    disposeMeterExporter();
  }

  private void disposeMeterExporter() {
    meterExporter.get().dispose();
  }


}
