/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metrics.impl;

import javax.inject.Inject;
import org.mule.metrics.api.MeterProvider;
import org.mule.metrics.api.meter.builder.MeterBuilder;
import org.mule.metrics.exporter.api.MeterExporter;
import org.mule.metrics.exporter.api.MeterExporterFactory;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.impl.meter.DefaultMeter;
import org.mule.metrics.impl.meter.repository.MeterRepository;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.LazyValue;

public class DefaultMeterProvider
implements MeterProvider,
Disposable {
    MeterExporterFactory meterExporterFactory;
    MeterExporterConfiguration meterExporterConfiguration;
    MeterRepository meterRepository = new MeterRepository();
    private final LazyValue<MeterExporter> meterExporter = new LazyValue(this::resolveMeterExporter);

    @Inject
    public DefaultMeterProvider(MeterExporterFactory meterExporterFactory, MeterExporterConfiguration meterExporterConfiguration) {
        this.meterExporterFactory = meterExporterFactory;
        this.meterExporterConfiguration = meterExporterConfiguration;
    }

    private MeterExporter resolveMeterExporter() {
        return this.meterExporterFactory.getMeterExporter(this.meterExporterConfiguration);
    }

    public MeterBuilder getMeterBuilder(String meterName) {
        return DefaultMeter.builder(meterName).withMeterExporter((MeterExporter)this.meterExporter.get()).withMeterRepository(this.meterRepository);
    }

    public void close() {
        this.disposeMeterExporter();
    }

    public MeterRepository getMeterRepository() {
        return this.meterRepository;
    }

    public void dispose() {
        this.disposeMeterExporter();
    }

    private void disposeMeterExporter() {
        ((MeterExporter)this.meterExporter.get()).dispose();
    }
}

