/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metrics.impl.instrument;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.metrics.api.instrument.LongGauge;
import org.mule.metrics.api.instrument.builder.InstrumentBuilder;
import org.mule.metrics.api.instrument.builder.LongGaugeBuilder;
import org.mule.metrics.api.meter.Meter;
import org.mule.metrics.exporter.api.MeterExporter;
import org.mule.metrics.impl.instrument.repository.InstrumentRepository;

public class DefaultLongGauge
implements LongGauge {
    private final String name;
    private final String description;
    private final String unit;
    private final Meter meter;
    private final Supplier<Long> valueSupplier;

    private DefaultLongGauge(String name, String description, String unit, Meter meter, Supplier<Long> valueSupplier) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.meter = meter;
        this.valueSupplier = valueSupplier;
    }

    public static DefaultLongGaugeBuilder builder(String gaugeName, Meter defaultMeter) {
        return new DefaultLongGaugeBuilder(gaugeName, defaultMeter);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public long getValueAsLong() {
        return this.valueSupplier.get();
    }

    public String getUnit() {
        return this.unit;
    }

    public static class DefaultLongGaugeBuilder
    implements LongGaugeBuilder {
        private final String name;
        private final Meter meter;
        private String description;
        private String unit;
        private Supplier<Long> valueSupplier;
        private MeterExporter meterExporter;
        private InstrumentRepository instrumentRepository;

        public DefaultLongGaugeBuilder(String name, Meter meter) {
            this.name = name;
            this.meter = meter;
        }

        public LongGaugeBuilder withValueSupplier(Supplier<Long> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        public InstrumentBuilder<LongGauge> withDescription(String description) {
            this.description = description;
            return this;
        }

        public InstrumentBuilder<LongGauge> withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public DefaultLongGaugeBuilder withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }

        public DefaultLongGaugeBuilder withInstrumentRepository(InstrumentRepository instrumentRepository) {
            this.instrumentRepository = instrumentRepository;
            return this;
        }

        public LongGauge build() {
            LongGauge longGauge = Optional.ofNullable(this.instrumentRepository).map(repository -> (LongGauge)repository.create(this.name, name -> this.doBuild())).orElseGet(this::doBuild);
            if (this.meterExporter != null) {
                this.meterExporter.enableExport(longGauge);
            }
            return longGauge;
        }

        private LongGauge doBuild() {
            return new DefaultLongGauge(this.name, this.description, this.unit, this.meter, this.valueSupplier);
        }
    }
}

