/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.endpoint;

import java.util.List;
import java.util.logging.Logger;
import org.mule.api.transport.Connector;
import org.mule.construct.Flow;
import org.mule.munit.common.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitSpringFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static Logger logger = Logger.getLogger("Bean definition Processor");
    protected boolean mockInbounds;
    protected boolean mockConnectors;
    protected List<String> mockingExcludedFlows;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.isMockInbounds() || this.isMockConnectors()) {
            String[] beanDefinitionNames;
            for (String name : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
                if (!Flow.class.getName().equals(beanDefinition.getBeanClassName()) || this.mockingExcludedFlows.contains(name)) continue;
                beanDefinition.getPropertyValues().removePropertyValue("messageSource");
            }
        }
        this.changeEndpointFactory(beanFactory);
        this.mockConnectors(beanFactory);
    }

    private void changeEndpointFactory(ConfigurableListableBeanFactory beanFactory) {
        GenericBeanDefinition endpointFactory = (GenericBeanDefinition)beanFactory.getBeanDefinition("_muleEndpointFactory");
        AbstractBeanDefinition abstractBeanDefinition = endpointFactory.cloneBeanDefinition();
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add("defaultFactory", (Object)abstractBeanDefinition);
        endpointFactory.setPropertyValues(propertyValues);
        endpointFactory.setBeanClassName(MockEndpointManager.class.getCanonicalName());
    }

    private void mockConnectors(ConfigurableListableBeanFactory beanFactory) {
        if (this.isMockConnectors()) {
            String[] beanNamesForType;
            for (String beanName : beanNamesForType = beanFactory.getBeanNamesForType(Connector.class)) {
                RootBeanDefinition beanDefinition = (RootBeanDefinition)RootBeanDefinition.class.cast(beanFactory.getBeanDefinition(beanName));
                if (beanDefinition.getFactoryMethodName() == null) {
                    ConnectorMethodInterceptorFactory.addFactoryDefinitionTo((AbstractBeanDefinition)beanDefinition).withConstructorArguments(beanDefinition.getBeanClass());
                    continue;
                }
                logger.info("The connector " + beanName + " cannot be mocked as it already has a factory method");
            }
        }
    }

    public void setMockInbounds(boolean mockInbounds) {
        this.mockInbounds = mockInbounds;
    }

    public void setMockingExcludedFlows(List<String> mockingExcludedFlows) {
        this.mockingExcludedFlows = mockingExcludedFlows;
    }

    public boolean isMockInbounds() {
        return this.mockInbounds;
    }

    public boolean isMockConnectors() {
        return this.mockConnectors;
    }

    public void setMockConnectors(boolean mockConnectors) {
        this.mockConnectors = mockConnectors;
    }
}

