/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.mp.MessageProcessorCall;
import org.mule.munit.common.mp.MessageProcessorId;
import org.mule.munit.common.mp.MockedMessageProcessorBehavior;
import org.mule.munit.common.mp.MockedMessageProcessorManager;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitMessageProcessorInterceptor
implements MethodInterceptor {
    private MessageProcessorId id;
    private Map<String, String> attributes;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent event = (MuleEvent)args[0];
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager();
        this.runSpyBeforeAssertions(manager, event);
        MessageProcessorCall messageProcessorCall = this.buildCall(event);
        MockedMessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.registerCall(event, manager, messageProcessorCall);
                throw behavior.getExceptionToThrow();
            }
            MunitUtils.copyMessage((DefaultMuleMessage)behavior.getReturnMuleMessage(), (DefaultMuleMessage)event.getMessage());
            this.registerCall(event, manager, messageProcessorCall);
            return event;
        }
        this.registerCall(event, manager, messageProcessorCall);
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MuleEvent event, MockedMessageProcessorManager manager, MessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
        this.runSpyAfterAssertions(manager, event);
    }

    private void runSpyAfterAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getAfterMessageProcessors());
    }

    private void runSpyBeforeAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getBeforeMessageProcessors());
    }

    private SpyAssertion getAssertionFrom(MockedMessageProcessorManager manager) {
        Map<MessageProcessorId, SpyAssertion> assertions = manager.getSpyAssertions();
        if (assertions.isEmpty()) {
            return null;
        }
        SpyAssertion spyAssertion = assertions.get(this.id);
        if (spyAssertion == null) {
            return null;
        }
        return spyAssertion;
    }

    private MessageProcessorCall buildCall(MuleEvent event) {
        MessageProcessorCall call = new MessageProcessorCall(this.id);
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, String> attrs : this.attributes.entrySet()) {
            Object evaluate = this.evaluate(attrs.getValue(), event);
            processed.put(attrs.getKey(), evaluate);
        }
        call.setAttributes(processed);
        return call;
    }

    private Object evaluate(String elementValue, MuleEvent event) {
        ExpressionManager expressionManager = this.getMuleContext().getExpressionManager();
        if (expressionManager.isExpression(elementValue)) {
            String compareTo = expressionManager.parse(elementValue, event);
        } else if (!StringUtils.isEmpty((String)elementValue)) {
            Object o = this.getMuleContext().getRegistry().lookupObject(elementValue);
            if (o != null) {
                Object compareTo = o;
            } else {
                String string = elementValue;
            }
        }
        return elementValue;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (MessageProcessor.class.isAssignableFrom(declaringClass) && method.getName().equals("process")) {
            return this.process(obj, args, proxy);
        }
        return proxy.invokeSuper(obj, args);
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager() {
        return (MockedMessageProcessorManager)this.getMuleContext().getRegistry().lookupObject(MockedMessageProcessorManager.ID);
    }

    public void setId(MessageProcessorId id) {
        this.id = id;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public MuleContext getMuleContext() {
        return MunitCore.getMuleContext();
    }
}

