/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.construct.FlowConstruct;
import org.mule.munit.common.matchers.Matcher;
import org.mule.munit.common.mp.MessageProcessorId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorCall {
    private MessageProcessorId messageProcessorId;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private FlowConstruct flowConstruct;
    private String fileName;
    private String lineNumber;

    public MessageProcessorCall(MessageProcessorId messageProcessorId) {
        this.messageProcessorId = messageProcessorId;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public MessageProcessorId getMessageProcessorId() {
        return this.messageProcessorId;
    }

    public boolean isCallOf(MessageProcessorId id) {
        return this.messageProcessorId.equals(id);
    }

    public int matchingWeight(MessageProcessorCall call) {
        if (this.messageProcessorId.equals(call.getMessageProcessorId())) {
            Map<String, Object> callAttributes = call.getAttributes();
            for (Map.Entry<String, Object> myAttribute : this.attributes.entrySet()) {
                if (this.callHasAttribute(callAttributes, myAttribute)) continue;
                return -1;
            }
            return this.attributes.size();
        }
        return -1;
    }

    private boolean callHasAttribute(Map<String, Object> callAttributes, Map.Entry<String, Object> myAttribute) {
        String myAttributeKey = myAttribute.getKey();
        return callAttributes.containsKey(myAttributeKey) && this.matchAttributeValue(callAttributes.get(myAttributeKey), myAttribute.getValue());
    }

    private boolean matchAttributeValue(Object value, Object matcher) {
        if (matcher instanceof Matcher) {
            return ((Matcher)matcher).match(value);
        }
        return matcher.equals(value);
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }
}

