/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.munit.common.mp.MessageProcessorCall;
import org.mule.munit.common.mp.MessageProcessorId;
import org.mule.munit.common.mp.MockedMessageProcessorBehavior;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockedMessageProcessorManager {
    public static String ID = "_muleMockMpManager";
    protected List<MockedMessageProcessorBehavior> behaviors = new ArrayList<MockedMessageProcessorBehavior>();
    protected List<MessageProcessorCall> calls = new LinkedList<MessageProcessorCall>();
    protected Map<MessageProcessorId, SpyAssertion> spyAssertions = new HashMap<MessageProcessorId, SpyAssertion>();

    public void reset() {
        this.behaviors.clear();
        this.calls.clear();
        this.spyAssertions.clear();
    }

    public List<MessageProcessorCall> findCallsFor(MessageProcessorId mpId, Map<String, Object> attributesMatchers) {
        ArrayList<MessageProcessorCall> expected = new ArrayList<MessageProcessorCall>();
        MessageProcessorCall matchingCall = new MessageProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (MessageProcessorCall call : this.calls) {
            if (matchingCall.matchingWeight(call) < 0) continue;
            expected.add(call);
        }
        return expected;
    }

    public MockedMessageProcessorBehavior getBetterMatchingBehavior(MessageProcessorCall messageProcessorCall) {
        AbstractMap.SimpleEntry<Integer, Object> bestMatchingBehavior = new AbstractMap.SimpleEntry<Integer, Object>(0, null);
        for (MockedMessageProcessorBehavior behavior : this.behaviors) {
            int matchingWeight = behavior.getMessageProcessorCall().matchingWeight(messageProcessorCall);
            if (matchingWeight < 0 || matchingWeight < (Integer)bestMatchingBehavior.getKey()) continue;
            bestMatchingBehavior.setValue(behavior);
        }
        return (MockedMessageProcessorBehavior)bestMatchingBehavior.getValue();
    }

    public Map<MessageProcessorId, SpyAssertion> getSpyAssertions() {
        return this.spyAssertions;
    }

    public synchronized void addBehavior(MockedMessageProcessorBehavior behavior) {
        this.behaviors.add(behavior);
    }

    public synchronized void addCall(MessageProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addSpyAssertion(MessageProcessorId messageProcessor, SpyAssertion assertionMessageProcessor) {
        this.spyAssertions.put(messageProcessor, assertionMessageProcessor);
    }

    public List<MessageProcessorCall> getCalls() {
        return new LinkedList<MessageProcessorCall>(this.calls);
    }
}

