/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mocking;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.common.mocking.MunitMockingTool;
import org.mule.munit.common.mocking.SpyProcess;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitSpy
extends MunitMockingTool {
    public MunitSpy(MuleContext muleContext) {
        super(muleContext);
    }

    public MunitSpy spyMessageProcessor(String name) {
        this.messageProcessorName = name;
        return this;
    }

    public MunitSpy ofNamespace(String namespace) {
        this.messageProcessorNamespace = namespace;
        return this;
    }

    public void running(List<SpyProcess> beforeCall, List<SpyProcess> afterCall) {
        this.getManager().addSpyAssertion(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace), this.createSpyAssertion(beforeCall, afterCall));
    }

    protected SpyAssertion createSpyAssertion(List<SpyProcess> beforeCall, List<SpyProcess> afterCall) {
        return new SpyAssertion(this.createMessageProcessors(beforeCall), this.createMessageProcessors(afterCall));
    }

    private ArrayList<MessageProcessor> createMessageProcessors(List<SpyProcess> beforeCall) {
        ArrayList<MessageProcessor> beforeMessageProcessors = new ArrayList<MessageProcessor>();
        beforeMessageProcessors.add(this.createMessageProcessorFromSpy(beforeCall));
        return beforeMessageProcessors;
    }

    private MessageProcessor createMessageProcessorFromSpy(final List<SpyProcess> beforeCall) {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                if (beforeCall != null) {
                    for (SpyProcess process : beforeCall) {
                        process.spy(event);
                    }
                }
                return event;
            }
        };
    }
}

