/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.processors.MessageProcessorManager;
import org.mule.munit.common.mp.MunitMessageProcessorCall;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockedMessageProcessorManager
extends MessageProcessorManager {
    public static String ID = "_muleMockMpManager";
    protected List<MunitMessageProcessorCall> calls = new LinkedList<MunitMessageProcessorCall>();
    protected Map<MessageProcessorId, SpyAssertion> spyAssertions = new HashMap<MessageProcessorId, SpyAssertion>();

    public void reset() {
        this.behaviors.clear();
        this.calls.clear();
        this.spyAssertions.clear();
    }

    public List<MessageProcessorCall> findCallsFor(MessageProcessorId mpId, Map<String, Object> attributesMatchers) {
        ArrayList<MessageProcessorCall> expected = new ArrayList<MessageProcessorCall>();
        MessageProcessorCall matchingCall = new MessageProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (MunitMessageProcessorCall call : this.calls) {
            if (matchingCall.matchingWeight((MessageProcessorCall)call) < 0) continue;
            expected.add(call);
        }
        return expected;
    }

    public Map<MessageProcessorId, SpyAssertion> getSpyAssertions() {
        return this.spyAssertions;
    }

    public synchronized void addCall(MunitMessageProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addSpyAssertion(MessageProcessorId messageProcessor, SpyAssertion assertionMessageProcessor) {
        this.spyAssertions.put(messageProcessor, assertionMessageProcessor);
    }

    public List<MunitMessageProcessorCall> getCalls() {
        return new LinkedList<MunitMessageProcessorCall>(this.calls);
    }
}

