
package org.mule.munit.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/mclient</code>.
 * 
 */
public class MClientNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new MClientConfigDefinitionParser());
        registerBeanDefinitionParser("call", new CallDefinitionParser());
        registerBeanDefinitionParser("dispatch", new DispatchDefinitionParser());
        registerBeanDefinitionParser("request", new RequestDefinitionParser());
    }

}
