/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.transport.PropertyScope;
import org.mule.modules.interceptor.matchers.mel.AnyClassMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.AnyMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.ContainsMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.EqMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.NotNullMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.NullMatcherFunction;
import org.mule.modules.interceptor.matchers.mel.RegexMatcherFunction;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.mel.assertions.ElementMatcher;
import org.mule.munit.mel.assertions.ElementMatcherFactory;
import org.mule.munit.mel.assertions.ElementMatchingAssertionMelFunction;
import org.mule.munit.mel.assertions.MessageHasElementAssertionCommand;
import org.mule.munit.mel.assertions.MessageHasElementAssertionMelFunction;
import org.mule.munit.mel.assertions.MessageMatchingAssertionMelFunction;
import org.mule.munit.mel.utils.FlowResultFunction;
import org.mule.munit.mel.utils.GetResourceFunction;
import org.mule.transport.NullPayload;

public class AssertModule
extends MunitSpringFactoryPostProcessor
implements ExpressionLanguageExtension {
    private static String wrapMessage(String message) {
        return message == null ? "" : message;
    }

    public void assertThat(String message, Object payloadIs, Object payload) {
        Assert.assertEquals((String)AssertModule.wrapMessage(message), (Object)payloadIs, (Object)payload);
    }

    public void assertTrue(String message, Boolean condition) {
        Assert.assertTrue((String)AssertModule.wrapMessage(message), (boolean)condition);
    }

    public void assertOnEquals(String message, Object expected, Object value) {
        Assert.assertEquals((String)AssertModule.wrapMessage(message), (Object)expected, (Object)value);
    }

    public void assertNotSame(String message, Object expected, Object value) {
        Assert.assertNotSame((String)AssertModule.wrapMessage(message), (Object)expected, (Object)value);
    }

    public void assertFalse(String message, Boolean condition) {
        Assert.assertFalse((String)AssertModule.wrapMessage(message), (boolean)condition);
    }

    public void assertNotNull(String message, Object payload) {
        Assert.assertFalse((String)AssertModule.wrapMessage(message), (boolean)(payload instanceof NullPayload));
    }

    public void assertNull(String message, Object payload) {
        Assert.assertTrue((String)AssertModule.wrapMessage(message), (boolean)(payload instanceof NullPayload));
    }

    public void fail(String message) {
        Assert.fail((String)AssertModule.wrapMessage(message));
    }

    public void configureContext(ExpressionLanguageContext context) {
        context.declareFunction("messageHasPropertyInAnyScopeCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                boolean contains = false;
                for (PropertyScope scope : PropertyScope.ALL_SCOPES) {
                    contains = contains || muleMessage.getProperty(param, scope) != null;
                }
                return contains;
            }
        }));
        context.declareFunction("messageHasInboundPropertyCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getInboundProperty(param) != null;
            }
        }));
        context.declareFunction("messageHasOutboundPropertyCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getOutboundProperty(param) != null;
            }
        }));
        context.declareFunction("messageHasSessionPropertyCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getProperty(param, PropertyScope.SESSION) != null;
            }
        }));
        context.declareFunction("messageHasInvocationPropertyCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getInvocationProperty(param) != null;
            }
        }));
        context.declareFunction("messageHasInboundAttachmentCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getInboundAttachment(param) != null;
            }
        }));
        context.declareFunction("messageHasOutboundAttachmentCalled", (ExpressionLanguageFunction)new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand(){

            public boolean messageHas(String param, MuleMessage muleMessage) {
                return muleMessage.getOutboundAttachment(param) != null;
            }
        }));
        context.declareFunction("messageInboundProperty", (ExpressionLanguageFunction)new MessageMatchingAssertionMelFunction(new ElementMatcherFactory(){

            public ElementMatcher build(String elementName, MuleMessage muleMessage) {
                return new ElementMatcher(muleMessage.getInboundProperty(elementName));
            }
        }));
        context.declareFunction("messageOutboundProperty", (ExpressionLanguageFunction)new MessageMatchingAssertionMelFunction(new ElementMatcherFactory(){

            public ElementMatcher build(String elementName, MuleMessage muleMessage) {
                return new ElementMatcher(muleMessage.getOutboundProperty(elementName));
            }
        }));
        context.declareFunction("messageInvocationProperty", (ExpressionLanguageFunction)new MessageMatchingAssertionMelFunction(new ElementMatcherFactory(){

            public ElementMatcher build(String elementName, MuleMessage muleMessage) {
                return new ElementMatcher(muleMessage.getInvocationProperty(elementName));
            }
        }));
        context.declareFunction("messageInboundAttachment", (ExpressionLanguageFunction)new MessageMatchingAssertionMelFunction(new ElementMatcherFactory(){

            public ElementMatcher build(String elementName, MuleMessage muleMessage) {
                return new ElementMatcher(muleMessage.getInboundAttachment(elementName));
            }
        }));
        context.declareFunction("messageOutboundAttachment", (ExpressionLanguageFunction)new MessageMatchingAssertionMelFunction(new ElementMatcherFactory(){

            public ElementMatcher build(String elementName, MuleMessage muleMessage) {
                return new ElementMatcher(muleMessage.getOutboundAttachment(elementName));
            }
        }));
        context.declareFunction("valueOf", (ExpressionLanguageFunction)new ElementMatchingAssertionMelFunction());
        context.declareFunction("eq", (ExpressionLanguageFunction)new EqMatcherFunction());
        context.declareFunction("anyBoolean", (ExpressionLanguageFunction)new AnyMatcherFunction(Boolean.class));
        context.declareFunction("anyByte", (ExpressionLanguageFunction)new AnyMatcherFunction(Byte.class));
        context.declareFunction("anyByteArray", (ExpressionLanguageFunction)new AnyMatcherFunction(byte[].class));
        context.declareFunction("anyInt", (ExpressionLanguageFunction)new AnyMatcherFunction(Integer.class));
        context.declareFunction("anyDouble", (ExpressionLanguageFunction)new AnyMatcherFunction(Double.class));
        context.declareFunction("anyFloat", (ExpressionLanguageFunction)new AnyMatcherFunction(Float.class));
        context.declareFunction("anyShort", (ExpressionLanguageFunction)new AnyMatcherFunction(Short.class));
        context.declareFunction("anyObject", (ExpressionLanguageFunction)new AnyMatcherFunction(Object.class));
        context.declareFunction("anyString", (ExpressionLanguageFunction)new AnyMatcherFunction(String.class));
        context.declareFunction("anyList", (ExpressionLanguageFunction)new AnyMatcherFunction(List.class));
        context.declareFunction("anySet", (ExpressionLanguageFunction)new AnyMatcherFunction(Set.class));
        context.declareFunction("anyMap", (ExpressionLanguageFunction)new AnyMatcherFunction(Map.class));
        context.declareFunction("anyCollection", (ExpressionLanguageFunction)new AnyMatcherFunction(Collection.class));
        context.declareFunction("isNull", (ExpressionLanguageFunction)new NullMatcherFunction());
        context.declareFunction("isNotNull", (ExpressionLanguageFunction)new NotNullMatcherFunction());
        context.declareFunction("any", (ExpressionLanguageFunction)new AnyClassMatcherFunction());
        context.declareFunction("matchRegex", (ExpressionLanguageFunction)new RegexMatcherFunction());
        context.declareFunction("contains", (ExpressionLanguageFunction)new ContainsMatcherFunction());
        context.declareFunction("resultOfScript", (ExpressionLanguageFunction)new FlowResultFunction());
        context.declareFunction("getResource", (ExpressionLanguageFunction)new GetResourceFunction());
    }
}

