/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractDefinitionParser
implements BeanDefinitionParser {
    private TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();

    protected boolean hasAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return value != null && !StringUtils.isBlank((String)value);
    }

    protected void setRef(BeanDefinitionBuilder builder, String propertyName, String ref) {
        if (!this.isMuleExpression(ref)) {
            builder.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(ref));
        } else {
            builder.addPropertyValue(propertyName, (Object)ref);
        }
    }

    protected boolean isMuleExpression(String value) {
        return value.startsWith(this.patternInfo.getPrefix()) || value.endsWith(this.patternInfo.getSuffix());
    }

    protected ManagedMap parseMap(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedMap managedMap = new ManagedMap();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        if (childDomElements.size() == 0) {
            childDomElements = DomUtils.getChildElements((Element)element);
        }
        for (Element childDomElement : childDomElements) {
            Object key = null;
            key = this.hasAttribute(childDomElement, "key-ref") ? new RuntimeBeanReference(childDomElement.getAttribute("key-ref")) : (this.hasAttribute(childDomElement, "key") ? childDomElement.getAttribute("key") : childDomElement.getTagName());
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedMap.put(key, (Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                    continue;
                }
                managedMap.put(key, (Object)childDomElement.getAttribute("value-ref"));
                continue;
            }
            managedMap.put(key, parserDelegate.parse(childDomElement));
        }
        return managedMap;
    }

    protected void parseMapAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedMap managedMap = this.parseMap(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedMap);
            }
        }
    }

    protected void attachProcessorDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", (Object)definition);
        } else if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
            propertyValues.addPropertyValue("enrichmentMessageProcessor", (Object)definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if (messageProcessors == null || messageProcessors.getValue() == null) {
                propertyValues.addPropertyValue("messageProcessors", (Object)new ManagedList());
            }
            List listMessageProcessors = (List)propertyValues.getPropertyValue("messageProcessors").getValue();
            listMessageProcessors.add(definition);
        }
    }

    protected void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParseDelegate<T> {
        public T parse(Element var1);
    }
}

