/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config.spring;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitDefinitionParser
implements BeanDefinitionParser {
    private Class mpClass;
    private List<String> attributes;
    private List<String> refAttributes;

    public MunitDefinitionParser(Class mpClass, List<String> attributes) {
        this(mpClass, attributes, new ArrayList<String>());
    }

    public MunitDefinitionParser(Class mpClass, List<String> attributes, List<String> refAttributes) {
        this.mpClass = mpClass;
        this.attributes = attributes;
        this.refAttributes = refAttributes;
    }

    public MunitDefinitionParser(Class mpClass) {
        this(mpClass, new ArrayList<String>(), new ArrayList<String>());
    }

    protected void attachProcessorDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", (Object)definition);
        } else if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
            propertyValues.addPropertyValue("enrichmentMessageProcessor", (Object)definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if (messageProcessors == null || messageProcessors.getValue() == null) {
                propertyValues.addPropertyValue("messageProcessors", (Object)new ManagedList());
            }
            List listMessageProcessors = (List)propertyValues.getPropertyValue("messageProcessors").getValue();
            listMessageProcessors.add(definition);
        }
    }

    protected void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)this.mpClass.getName());
        builder.setScope("prototype");
        for (String attribute : this.attributes) {
            if (element.getAttribute(attribute) == null || StringUtils.isBlank((String)element.getAttribute(attribute))) continue;
            builder.addPropertyValue(attribute, (Object)element.getAttribute(attribute));
        }
        for (String refAttribute : this.refAttributes) {
            String attrWithRefAttached = refAttribute + "-ref";
            if (element.getAttribute(attrWithRefAttached) == null || StringUtils.isBlank((String)element.getAttribute(attrWithRefAttached))) continue;
            if (element.getAttribute(attrWithRefAttached).startsWith("#")) {
                builder.addPropertyValue(refAttribute, (Object)element.getAttribute(attrWithRefAttached));
                continue;
            }
            builder.addPropertyValue(refAttribute, (Object)new RuntimeBeanReference(element.getAttribute(attrWithRefAttached)));
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContent, (BeanDefinition)definition);
        return definition;
    }
}

