/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mel.utils;

import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;

/**
 * <p>
 * This is an extension that allows you to obtain a bean from the MuleContext by using its name.
 * <p/>
 * <pre>
 *         {@code
 *           <munit:assert-on-equals expectedValue="#[getBeanFromMuleContext('bean_name')]" actualValue="#[payload]"/>
 *         }
 *     </pre>
 *
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.6.0
 */
public class GetBeanFromMuleContextFunction implements ExpressionLanguageFunction{
    private MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Object call(final Object[] params, ExpressionLanguageContext context) {
        if (params == null || params.length != 1
                || !(params[0] instanceof String)) {
            throw new IllegalArgumentException(
                    "You must provide one parameter that "
                            + "indicates the name of the bean you're looking for");
        }
        String beanName = (String) params[0];
        return muleContext.getRegistry().lookupObject(beanName);

    }





}
