/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mocking;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.OutboundBehavior;
import org.mule.munit.common.mocking.SpyProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointMocker {
    private MuleContext muleContext;
    private String address;
    private List<SpyProcess> process;

    public EndpointMocker(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public EndpointMocker whenEndpointWithAddress(String address) {
        this.address = address;
        return this;
    }

    public EndpointMocker withIncomingMessageSatisfying(List<SpyProcess> process) {
        this.process = process;
        return this;
    }

    public void thenReturn(MuleMessage message) {
        OutboundBehavior behavior = new OutboundBehavior(message, this.createMessageProcessorFromSpy(this.process));
        MockEndpointManager factory = (MockEndpointManager)this.muleContext.getRegistry().lookupObject("_muleEndpointFactory");
        factory.addBehavior(this.address, behavior);
    }

    protected List<MessageProcessor> createMessageProcessorFromSpy(final List<SpyProcess> process) {
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        messageProcessors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                if (process != null) {
                    for (SpyProcess spyProcess : process) {
                        spyProcess.spy(event);
                    }
                }
                return event;
            }
        });
        return messageProcessors;
    }
}

