/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import net.sf.cglib.proxy.MethodProxy;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.modules.interceptor.processors.AbstractMessageProcessorInterceptor;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.mp.MockedMessageProcessorManager;
import org.mule.munit.common.mp.MunitMessageProcessorCall;
import org.mule.munit.common.mp.SpyAssertion;

public class MunitMessageProcessorInterceptor
extends AbstractMessageProcessorInterceptor {
    private String fileName;
    private String lineNumber;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent event = (MuleEvent)args[0];
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager(event.getMuleContext());
        MunitMessageProcessorCall messageProcessorCall = this.buildCall(event);
        this.runSpyAssertion(manager.getBetterMatchingBeforeSpyAssertion(messageProcessorCall), event);
        this.registerCall(manager, messageProcessorCall);
        MessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), event);
                throw behavior.getExceptionToThrow();
            }
            if (behavior.getMuleMessageTransformer() != null) {
                event.setMessage(behavior.getMuleMessageTransformer().transform(event.getMessage()));
            }
            this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), event);
            return event;
        }
        Object o = this.invokeSuper(obj, args, proxy);
        this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), (MuleEvent)o);
        return o;
    }

    protected Object invokeSuper(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAssertion(SpyAssertion spyAssertion, MuleEvent event) {
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getMessageProcessors());
    }

    private MunitMessageProcessorCall buildCall(MuleEvent event) {
        MunitMessageProcessorCall call = new MunitMessageProcessorCall(this.id);
        call.setAttributes(this.getAttributes(event));
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager(MuleContext muleContext) {
        return (MockedMessageProcessorManager)((Object)muleContext.getRegistry().lookupObject(MockedMessageProcessorManager.ID));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }
}

