/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.lang.reflect.Method;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodProxy;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.modules.interceptor.processors.AbstractMessageProcessorInterceptor;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.mp.MockedMessageProcessorManager;
import org.mule.munit.common.mp.MunitMessageProcessorCall;
import org.mule.munit.common.mp.SpyAssertion;
import org.mule.processor.AbstractInterceptingMessageProcessorBase;

public class MunitMessageProcessorInterceptor
extends AbstractMessageProcessorInterceptor {
    private String fileName;
    private String lineNumber;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent originalEvent = (MuleEvent)args[0];
        MuleEvent event = DefaultMuleEvent.copy((MuleEvent)originalEvent);
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager(event.getMuleContext());
        MunitMessageProcessorCall messageProcessorCall = this.buildCall(event);
        this.runSpyAssertion(manager.getBetterMatchingBeforeSpyAssertion(messageProcessorCall), event);
        this.registerCall(manager, messageProcessorCall);
        MessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), event);
                throw behavior.getExceptionToThrow();
            }
            if (behavior.getMuleMessageTransformer() != null) {
                event.setMessage(behavior.getMuleMessageTransformer().transform(event.getMessage()));
            }
            this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), event);
            return this.handleInterceptingMessageProcessors(obj, event);
        }
        Object o = this.invokeSuper(obj, args, proxy);
        this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), (MuleEvent)o);
        return o;
    }

    protected Object handleInterceptingMessageProcessors(Object obj, MuleEvent event) throws Throwable {
        if (AbstractInterceptingMessageProcessorBase.class.isAssignableFrom(obj.getClass())) {
            return this.processNext(obj, event);
        }
        return event;
    }

    protected Object processNext(Object obj, MuleEvent event) throws Throwable {
        String methodName = "processNext";
        Class<MuleEvent> returnType = MuleEvent.class;
        Class<MuleEvent> argumentType = MuleEvent.class;
        Type[] argumentTypes = new Type[]{Type.getType(argumentType)};
        Signature signature = new Signature(methodName, Type.getType(returnType), argumentTypes);
        MethodProxy methodProxy = MethodProxy.find(obj.getClass(), (Signature)signature);
        if (methodProxy != null) {
            Object[] args = new Object[]{event};
            return methodProxy.invoke(obj, args);
        }
        Method method = AbstractInterceptingMessageProcessorBase.class.getDeclaredMethod(methodName, argumentType);
        method.setAccessible(true);
        return method.invoke(obj, event);
    }

    protected Object invokeSuper(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAssertion(SpyAssertion spyAssertion, MuleEvent event) {
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getMessageProcessors());
    }

    private MunitMessageProcessorCall buildCall(MuleEvent event) {
        MunitMessageProcessorCall call = new MunitMessageProcessorCall(this.id);
        call.setAttributes(this.getAttributes(event));
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager(MuleContext muleContext) {
        return (MockedMessageProcessorManager)((Object)muleContext.getRegistry().lookupObject(MockedMessageProcessorManager.ID));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }
}

