/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.munit.processors.OutboundEndpointMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class OutboundEndpointDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(OutboundEndpointDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)OutboundEndpointMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [outbound-endpoint] within the connector [mock] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [outbound-endpoint] within the connector [mock] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"outboundEndpoint");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        this.parseProperty(builder, element, "address", "address");
        if (this.hasAttribute(element, "returnPayload-ref")) {
            if (element.getAttribute("returnPayload-ref").startsWith("#")) {
                builder.addPropertyValue("returnPayload", (Object)element.getAttribute("returnPayload-ref"));
            } else {
                builder.addPropertyValue("returnPayload", (Object)("#[registry:" + element.getAttribute("returnPayload-ref") + "]"));
            }
        }
        if (this.hasAttribute(element, "exception-ref")) {
            if (element.getAttribute("exception-ref").startsWith("#")) {
                builder.addPropertyValue("exception", (Object)element.getAttribute("exception-ref"));
            } else {
                builder.addPropertyValue("exception", (Object)("#[registry:" + element.getAttribute("exception-ref") + "]"));
            }
        }
        if (this.hasAttribute(element, "thenApplyTransformer-ref")) {
            if (element.getAttribute("thenApplyTransformer-ref").startsWith("#")) {
                builder.addPropertyValue("thenApplyTransformer", (Object)element.getAttribute("thenApplyTransformer-ref"));
            } else {
                builder.addPropertyValue("thenApplyTransformer", (Object)("#[registry:" + element.getAttribute("thenApplyTransformer-ref") + "]"));
            }
        }
        this.parseMapAndSetProperty(element, builder, "returnInvocationProperties", "return-invocation-properties", "return-invocation-property", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

            public String parse(Element element) {
                return element.getTextContent();
            }
        });
        this.parseMapAndSetProperty(element, builder, "returnInboundProperties", "return-inbound-properties", "return-inbound-property", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

            public String parse(Element element) {
                return element.getTextContent();
            }
        });
        this.parseMapAndSetProperty(element, builder, "returnSessionProperties", "return-session-properties", "return-session-property", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

            public String parse(Element element) {
                return element.getTextContent();
            }
        });
        this.parseMapAndSetProperty(element, builder, "returnOutboundProperties", "return-outbound-properties", "return-outbound-property", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

            public String parse(Element element) {
                return element.getTextContent();
            }
        });
        this.parseNestedProcessorAsListAndSetProperty(element, "assertions", parserContext, MessageProcessorChainFactoryBean.class, builder, "assertions");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

