/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.munit.holders.AttributeExpressionHolder;
import org.mule.munit.processors.ThrowAnMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ThrowAnDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(ThrowAnDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)ThrowAnMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [throw-an] within the connector [mock] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [throw-an] within the connector [mock] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"throwAn");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (this.hasAttribute(element, "exception-ref")) {
            if (element.getAttribute("exception-ref").startsWith("#")) {
                builder.addPropertyValue("exception", (Object)element.getAttribute("exception-ref"));
            } else {
                builder.addPropertyValue("exception", (Object)("#[registry:" + element.getAttribute("exception-ref") + "]"));
            }
        }
        this.parseProperty(builder, element, "whenCalling", "whenCalling");
        this.parseListAndSetProperty(element, builder, "withAttributes", "with-attributes", "with-attribute", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<BeanDefinition>(){

            public BeanDefinition parse(Element element) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AttributeExpressionHolder.class);
                ThrowAnDefinitionParser.this.parseProperty(builder, element, "name", "name");
                if (ThrowAnDefinitionParser.this.hasAttribute(element, "whereValue-ref")) {
                    if (element.getAttribute("whereValue-ref").startsWith("#")) {
                        builder.addPropertyValue("whereValue", (Object)element.getAttribute("whereValue-ref"));
                    } else {
                        builder.addPropertyValue("whereValue", (Object)("#[registry:" + element.getAttribute("whereValue-ref") + "]"));
                    }
                }
                return builder.getBeanDefinition();
            }
        });
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

