/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.NestedProcessorChain;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.munit.Attribute;
import org.mule.munit.MockModule;
import org.mule.munit.common.MunitCore;
import org.mule.munit.holders.AttributeExpressionHolder;
import org.mule.munit.transformers.AttributeExpressionHolderTransformer;
import org.mule.util.TemplateParser;

public abstract class AbstractMockMessageProcessor
implements Initialisable,
MessageProcessor,
MuleContextAware,
FlowConstructAware {
    protected FlowConstruct flowConstruct;
    protected Object moduleObject;
    protected MuleContext muleContext;
    protected ExpressionManager expressionManager;
    protected TemplateParser.PatternInfo patternInfo;
    protected AtomicInteger retryCount;
    protected int retryMax;

    public void initialise() throws InitialisationException {
        this.retryCount = new AtomicInteger();
        this.expressionManager = this.muleContext.getExpressionManager();
        this.patternInfo = TemplateParser.createMuleStyleParser().getStyle();
        try {
            this.moduleObject = this.findOrCreate(MockModule.class, true);
        }
        catch (IllegalAccessException e) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
        }
        catch (InstantiationException e) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
        }
        catch (ConfigurationException e) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(CoreMessages.initialisationFailure((String)"org.mule.munit.MockModule"), (Throwable)e, (Initialisable)this);
        }
    }

    protected final Object findOrCreate(Class<?> moduleClass, boolean shouldAutoCreate) throws IllegalAccessException, InstantiationException, ConfigurationException, RegistrationException {
        Object temporaryObject = this.moduleObject;
        if (temporaryObject == null && (temporaryObject = this.muleContext.getRegistry().lookupObject(moduleClass)) == null) {
            if (shouldAutoCreate) {
                temporaryObject = moduleClass.newInstance();
                this.muleContext.getRegistry().registerObject(moduleClass.getName(), temporaryObject);
            } else {
                throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot find object"));
            }
        }
        return temporaryObject;
    }

    protected MockModule getModule(MuleEvent event, String methodName) throws MessagingException {
        MockModule castedModuleObject;
        if (this.moduleObject instanceof String) {
            castedModuleObject = (MockModule)this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate((String)methodName), event, (Throwable)new RuntimeException("Cannot find the configuration specified by the org.mule.munit.config-ref attribute."));
            }
        } else {
            castedModuleObject = (MockModule)this.moduleObject;
        }
        return castedModuleObject;
    }

    protected Object evaluate(MuleMessage muleMessage, Object source) {
        if (source instanceof String) {
            String stringSource = (String)source;
            if (stringSource.startsWith(this.patternInfo.getPrefix()) && stringSource.endsWith(this.patternInfo.getSuffix())) {
                return this.expressionManager.evaluate(stringSource, muleMessage);
            }
            return this.expressionManager.parse(stringSource, muleMessage);
        }
        return source;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MockModule module = this.getModule(event, this.getProcessor());
        try {
            this.retryCount.getAndIncrement();
            this.doProcess(event, module);
            this.retryCount.set(0);
            return event;
        }
        catch (AssertionError error) {
            AssertionError exception = new AssertionError((Object)this.getMessage(error));
            ((Throwable)((Object)exception)).setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)this.muleContext).toArray(new StackTraceElement[0]));
            throw exception;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)this.getProcessor()), event, (Throwable)e);
        }
    }

    protected abstract void doProcess(MuleEvent var1, MockModule var2) throws Exception;

    protected abstract String getProcessor();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    public void setRetryMax(int value) {
        this.retryMax = value;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    private String getMessage(AssertionError error) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((String)message)) {
            return this.getProcessor();
        }
        return message;
    }

    protected List<Attribute> transformAttributes(Object attributes, MuleEvent muleEvent) throws TransformerMessagingException {
        AttributeExpressionHolderTransformer transformerAttribute = new AttributeExpressionHolderTransformer();
        transformerAttribute.setMuleContext(this.muleContext);
        ArrayList<Attribute> transformedAttribute = new ArrayList<Attribute>();
        if (attributes != null) {
            for (AttributeExpressionHolder a : (List)attributes) {
                transformedAttribute.add((Attribute)transformerAttribute.transform(a, null, muleEvent));
            }
        }
        return transformedAttribute;
    }

    protected List<NestedProcessor> transformAssertions(Object assertions, MuleEvent muleEvent) {
        ArrayList<NestedProcessor> transformedAssertions = new ArrayList<NestedProcessor>();
        if (assertions != null) {
            for (MessageProcessor messageProcessor : (List)assertions) {
                transformedAssertions.add((NestedProcessor)new NestedProcessorChain(muleEvent, this.muleContext, messageProcessor));
            }
        }
        return transformedAssertions;
    }
}

