/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.munit.config.MockModuleConfigDefinitionParser;
import org.mule.munit.config.OutboundEndpointDefinitionParser;
import org.mule.munit.config.SpyDefinitionParser;
import org.mule.munit.config.ThrowAnDefinitionParser;
import org.mule.munit.config.VerifyCallDefinitionParser;
import org.mule.munit.config.WhenDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class MockNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(MockNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mock] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mock] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", new MockModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("when", new WhenDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("when", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("spy", new SpyDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("spy", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("throw-an", new ThrowAnDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("throw-an", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("verify-call", new VerifyCallDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("verify-call", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("outbound-endpoint", new OutboundEndpointDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("outbound-endpoint", "@Processor", ex);
        }
    }
}

