/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.NotificationListener;

public class MunitRemoteRunner {
    Socket requestSocket;
    ObjectOutputStream out;
    ObjectInputStream in;
    String message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int port, String path, String resource) {
        try {
            this.requestSocket = new Socket("localhost", port);
            System.out.println("Connected to localhost in port " + port);
            this.out = new ObjectOutputStream(this.requestSocket.getOutputStream());
            this.out.flush();
            MunitSuiteRunner runner = new MunitSuiteRunner(resource);
            runner.setNotificationListener(new NotificationListener(){

                public void notifyStartOf(MunitTest test) {
                    try {
                        MunitRemoteRunner.this.out.writeObject("1;" + test.getName());
                        MunitRemoteRunner.this.out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void notify(TestResult testResult) {
                    try {
                        if (testResult.getError() != null) {
                            MunitRemoteRunner.this.out.writeObject("3;" + testResult.getTestName() + ";'" + testResult.getError().getFullMessage() + "'");
                            MunitRemoteRunner.this.out.flush();
                        } else if (testResult.getFailure() != null) {
                            MunitRemoteRunner.this.out.writeObject("2;" + testResult.getTestName() + ";'" + testResult.getFailure().getFullMessage() + "'");
                            MunitRemoteRunner.this.out.flush();
                        } else {
                            MunitRemoteRunner.this.out.writeObject("4;" + testResult.getTestName());
                            MunitRemoteRunner.this.out.flush();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void notifyEnd(SuiteResult result) {
                }
            });
            this.out.writeObject("0;" + runner.getNumberOfTests());
            this.out.writeObject("5;" + path);
            runner.run();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        finally {
            try {
                this.out.close();
                this.requestSocket.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        String resource = null;
        int port = -1;
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-resource")) {
                resource = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-port")) {
                port = Integer.valueOf(args[i + 1]);
            }
            if (!args[i].equalsIgnoreCase("-path")) continue;
            path = args[i + 1];
        }
        MunitRemoteRunner server = new MunitRemoteRunner();
        server.run(port, path, resource);
    }
}

