/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkListener;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.AnnotationsConfigurationBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.runner.MunitPluginFactory;
import org.mule.munit.runner.mule.context.MockingConfiguration;
import org.mule.munit.runner.mule.context.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.tck.TestingWorkListener;
import org.mule.util.ClassUtils;

public class MuleContextManager {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = AnnotationsConfigurationBuilder.class.getCanonicalName();
    private MockingConfiguration configuration;
    private Collection<MunitPlugin> plugins;

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources) throws Exception {
        MuleContext context = this.createMule(resources);
        return this.startMule(context);
    }

    public MuleContext startMule(MuleContext context) throws MuleException {
        context.start();
        this.startPlugins();
        return context;
    }

    public void killMule(MuleContext muleContext) {
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
                this.stopPlugins();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (muleContext != null && !muleContext.isDisposed()) {
            muleContext.dispose();
            this.disposePlugins();
        }
    }

    public MuleContext createMule(String resources) throws Exception {
        this.defineLogOutput(resources);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builders = new ArrayList<Object>();
        builders.add(new SimpleConfigurationBuilder((Map)this.properties()));
        if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, this.getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, this.getClass()));
        }
        builders.add(this.getBuilder(resources));
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContext((MuleContextBuilder)contextBuilder);
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        context.getNotificationManager().setNotificationDynamic(true);
        context.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        this.plugins = new MunitPluginFactory().loadPlugins(context);
        this.initialisePlugins();
        return context;
    }

    private Properties properties() {
        Properties properties;
        Properties properties2 = properties = this.configuration == null ? null : this.configuration.getStartUpProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("app.home") == null) {
            properties.setProperty("app.home", new File(this.getClass().getResource("/").getPath()).getAbsolutePath());
        }
        return properties;
    }

    private void defineLogOutput(String resources) throws IOException {
        String path = System.getProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY);
        if (path != null) {
            String name = resources.replace(".xml", "");
            Logger logger = Logger.getRootLogger();
            logger.removeAllAppenders();
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), String.format(path, name)));
            logger.setLevel(Level.INFO);
        }
    }

    protected ConfigurationBuilder getBuilder(String resources) throws Exception {
        return new MunitSpringXmlConfigurationBuilder(resources, this.configuration);
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    private void startPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
        }
    }

    private void disposePlugins() {
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
        }
    }

    private void stopPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    private void initialisePlugins() throws InitialisationException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
        }
    }
}

