/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.munit.config.MunitAfterTest;
import org.mule.munit.config.MunitBeforeTest;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.config.MunitTestFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuiteBuilder<T, E> {
    protected MuleContext muleContext;
    protected List<E> tests = new ArrayList();

    protected abstract T createSuite(String var1);

    protected abstract E test(List<MunitFlow> var1, MunitTestFlow var2, List<MunitFlow> var3);

    protected SuiteBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public T build(String suiteName) {
        return this.build(suiteName, null);
    }

    public T build(String suiteName, String testToRunName) {
        List<MunitFlow> before = this.lookupFlows(MunitBeforeTest.class);
        List<MunitFlow> after = this.lookupFlows(MunitAfterTest.class);
        Collection<MunitTestFlow> flowConstructs = this.lookupTests();
        for (MunitTestFlow flowConstruct : flowConstructs) {
            this.tests.add(this.test(before, this.flagIgnoreTest(flowConstruct, testToRunName), after));
        }
        return this.createSuite(suiteName);
    }

    private MunitTestFlow flagIgnoreTest(MunitTestFlow munitTestFlow, String testToRunName) {
        if (StringUtils.isBlank((String)testToRunName) || munitTestFlow.isIgnore()) {
            return munitTestFlow;
        }
        if (munitTestFlow.getName().matches(testToRunName)) {
            munitTestFlow.setIgnore(false);
        } else {
            munitTestFlow.setIgnore(true);
        }
        return munitTestFlow;
    }

    private List<MunitFlow> lookupFlows(Class munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }

    private Collection<MunitTestFlow> lookupTests() {
        return new ArrayList<MunitTestFlow>(this.muleContext.getRegistry().lookupObjects(MunitTestFlow.class));
    }
}

