/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote;

import java.io.IOException;
import java.io.ObjectOutput;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.remote.MessageBuilder;

public class RemoteRunnerNotificationListener
implements NotificationListener {
    private ObjectOutput out;

    public RemoteRunnerNotificationListener(ObjectOutput out) {
        this.out = out;
    }

    public void notifyRuntimeStartFailure(Notification notification) {
        this.sendMessage(MessageBuilder.buildRuntimeStartFailureMessage(notification.getFullMessage()));
    }

    public void notifyNumberOfTest(int numberOfTests) {
        this.sendMessage(MessageBuilder.buildNuberOfTestsMessage(String.valueOf(numberOfTests)));
    }

    public void notifyStartOf(MunitTest test) {
        this.sendMessage(MessageBuilder.buildNewTestMessage(test.getName()));
    }

    public void notify(TestResult testResult) {
        if (testResult.getError() != null) {
            this.sendMessage(MessageBuilder.buildTestErroMessage(testResult.getTestName(), testResult.getError().getFullMessage()));
        } else if (testResult.getFailure() != null) {
            this.sendMessage(MessageBuilder.buildTestFailureMessage(testResult.getTestName(), testResult.getFailure().getFullMessage()));
        } else {
            this.sendMessage(MessageBuilder.buildTestFinishedMessage(testResult.getTestName()));
        }
    }

    public void notifyIgnored(TestResult testResult) {
        this.sendMessage(MessageBuilder.buildTestIgnoredMessage(testResult.getName()));
    }

    public void notifyEnd(SuiteResult result) {
    }

    public void notifyTestRunEnd(String testFullPath) {
        this.sendMessage(MessageBuilder.buildTestRunFinishedMessage(testFullPath));
    }

    private void sendMessage(String message) {
        try {
            this.out.writeObject(message);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

