/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule;

import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.MunitRunner;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;


/**
 * <p>
 * The Munit test runner
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitSuiteRunner {

    private MuleContext muleContext;
    private MunitSuite suite;
    private TestOutputHandler handler = new DefaultOutputHandler();
    private MuleContextManager muleContextManager = new MuleContextManager(null);


    public MunitSuiteRunner(String resources) {
        this(resources, null);
    }

    public MunitSuiteRunner(String resources, String testToRunName) {
        try {
            muleContext = muleContextManager.startMule(resources);

            suite = new MunitSuiteBuilder(muleContext, handler).build(resources, testToRunName);

        } catch (Exception e) {
            muleContextManager.killMule(muleContext);
            throw new RuntimeException(e);
        }
    }

    public SuiteResult run() {
        return new MunitRunner<SuiteResult>(handler, muleContextManager, muleContext) {

            @Override
            protected SuiteResult runSuite() throws Exception {
                return suite.run();
            }

            @Override
            protected String getSuiteName() {
                return suite.getName();
            }
        }.run();
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.suite.setNotificationListener(notificationListener);
    }


    public int getNumberOfTests() {
        return suite.getNumberOfTests();
    }


}
